<?php

namespace WeDevs\Wpuf\Pro;

use Plugin_Upgrader;
use WP_Ajax_Upgrader_Skin;

/**
 * The installer class
 *
 * @since 4.0.0
 */
class Installer {

    /**
     * Install the WP User Frontend plugin via ajax
     *
     * @since 2.4.2
     *
     * @return json
     */
    public function install_wpuf_free() {
        check_ajax_referer( 'wpuf-pro-installer-nonce' );

        include_once ABSPATH . 'wp-admin/includes/plugin-install.php';
        include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';

        $plugin = 'wp-user-frontend';
        $api    = plugins_api(
            'plugin_information', [
                'slug'   => $plugin,
                'fields' => [ 'sections' => false ],
            ]
        );

        $upgrader = new Plugin_Upgrader( new WP_Ajax_Upgrader_Skin() );
        $result   = $upgrader->install( $api->download_link );

        if ( is_wp_error( $result ) ) {
            wp_send_json_error( $result );
        }

        $result = activate_plugin( 'wp-user-frontend/wpuf.php' );

        if ( is_wp_error( $result ) ) {
            wp_send_json_error( $result );
        }

        // check whether the version of wpuf free is prior to the code restructure
        if ( defined( 'WPUF_VERSION' ) && version_compare( WPUF_VERSION, '4.0.0', '<' ) ) {
            add_action( 'admin_notices', [ $this, 'wpuf_upgrade_notice' ] );

            deactivate_plugins( WPUF_FILE );
        }

        wp_send_json_success();
    }
}
